<?php
// dash.php — DEMO / PRACTICE ONLY
session_start();
if (empty($_SESSION['logged_in'])) { header('Location: index.php'); exit; }

$accountName = 'Robert McFerran';
$currency = 'GBP';

/*
|--------------------------------------------------------------------------
| FINAL AVAILABLE BALANCE (CLIMAX)
|--------------------------------------------------------------------------
*/
$balance = 10000000.00;

/*
|--------------------------------------------------------------------------
| ORIGINAL TRANSACTIONS (FIXED & MATCHED)
| Mostly FedEx Withdrawals, same amounts & dates as old
|--------------------------------------------------------------------------
*/
$transactions = [
 
  ['date'=>'2026-02-05','desc'=>'FedEx Deposit — Deposits Transfer','type'=>'credit','amount'=>10000000],
];

function money($amt,$cur){
  return ($cur==='GBP'?'£':'') . number_format($amt,2);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Account Dashboard | BOA</title>
<style>
:root{ --red:#b30000; --bg:#f4f6f8; --card:#ffffff; --muted:#6b7280; }
*{ box-sizing:border-box; font-family: Inter, Arial, Helvetica, sans-serif; }
body{ margin:0; background:var(--bg); color:#111827; }
.topbar{
  background:linear-gradient(90deg,var(--red),#d10000);
  color:#fff; padding:16px 28px; display:flex; align-items:center; justify-content:space-between;
}
.topbar a{ color:#fff; text-decoration:none; font-weight:800; }
.container{ max-width:1200px; margin:26px auto 26px 240px; padding:0 18px; }
.grid{ display:grid; grid-template-columns:1.2fr .8fr; gap:22px; }
.card{ background:var(--card); border-radius:16px; box-shadow:0 12px 30px rgba(0,0,0,.08); padding:22px; }
.badge{ background:#fee2e2; color:var(--red); padding:6px 10px; border-radius:999px; font-weight:800; font-size:12px; }
.name{ font-size:26px; font-weight:900; margin:8px 0 2px; }
.sub{ color:var(--muted); }
.balance{ margin-top:12px; border:1px solid #f1f5f9; border-radius:14px; padding:18px; }
.balance .lbl{ color:var(--muted); font-weight:700; }
.balance .amt{ font-size:34px; font-weight:900; color:var(--red); }
.kpis{ display:grid; grid-template-columns:repeat(3,1fr); gap:12px; margin-top:12px; }
.kpi{ background:#fafafa; border-radius:12px; padding:14px; border:1px solid #f1f5f9; }
.table{ width:100%; border-collapse:separate; border-spacing:0 10px; }
.table th{ font-size:12px; color:var(--muted); text-align:left; }
.table td{ background:#fff; padding:14px 10px; }
.tag{ padding:6px 10px; border-radius:999px; font-weight:800; font-size:12px; }
.debit{ background:#fee2e2; color:#7f1d1d; }
.footer{ text-align:center; color:var(--muted); font-size:12px; margin:24px 0; }
@media(max-width:900px){ .container{ margin-left:0; } .grid{ grid-template-columns:1fr; } }
</style>
</head>
<body>

<div class="topbar">
  <div>Secure Online Banking <span style="font-weight:400">(BOA)</span></div>
  <a href="logout.php">Logout</a>
</div>

<?php include 'side.php'; ?>

<div class="container">
  <div class="grid">
    <div class="card">
      <span class="badge">Primary Account</span>
      <div class="name"><?= htmlspecialchars($accountName) ?></div>
      <div class="sub">Client ID • 1417729921</div>

      <div class="balance">
        <div class="lbl">Available Balance</div>
        <div class="amt"><?= money($balance,$currency) ?></div>
      </div>

      <div class="kpis">
        <div class="kpi"><strong>Global</strong><div class="sub">Account Scope</div></div>
        <div class="kpi"><strong>High</strong><div class="sub">Liquidity Rating</div></div>
        <div class="kpi"><strong>Enabled</strong><div class="sub">International Wires</div></div>
      </div>
    </div>

    <div class="card">
      <h3>Account Insights</h3>
      <p class="sub">High-value FedEx logistics withdrawals with a maintained reserve balance of $30,000.</p>
    </div>
  </div>

  <div class="card" style="margin-top:22px;">
    <h3>Transaction History</h3>
    <table class="table">
      <thead>
        <tr>
          <th>Date</th>
          <th>Description</th>
          <th>Type</th>
          <th style="text-align:right">Amount</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($transactions as $t): ?>
        <tr>
          <td><?= htmlspecialchars($t['date']) ?></td>
          <td><?= htmlspecialchars($t['desc']) ?></td>
          <td><span class="tag debit">CREDIT</span></td>
          <td style="text-align:right;font-weight:900;">-<?= money($t['amount'],$currency) ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <div class="footer">© 2026 Bank of America Corporation.</div>
</div>

</body>
</html>