
<?php
// login.php — DEMO / PRACTICE ONLY
session_start();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Demo-only credentials (for practice)
    $demoEmail = 'stephen2102r@gmail.com';
    $demoPassword = 'John1234';

    if ($_POST['email'] === $demoEmail && $_POST['password'] === $demoPassword) {
        $_SESSION['logged_in'] = true;
        header('Location: dash.php');
        exit;
    } else {
        $error = 'Invalid login details';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title> BOA | Online Banking | Log In | User ID </title>
    <style>
        * { box-sizing: border-box; font-family: Arial, Helvetica, sans-serif; }
        body {
            margin: 0;
            background: #f4f6f8;
        }
        .header {
            background: #b30000;
            padding: 18px 30px;
            color: #fff;
            font-size: 22px;
            font-weight: bold;
        }
        .container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: calc(100vh - 70px);
        }
        .login-box {
            background: #fff;
            width: 380px;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);
        }
        .login-box h2 {
            margin-bottom: 20px;
            color: #b30000;
            text-align: center;
        }
        label {
            font-size: 14px;
            font-weight: bold;
            display: block;
            margin-bottom: 6px;
        }
        input {
            width: 100%;
            padding: 12px;
            margin-bottom: 18px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        button {
            width: 100%;
            padding: 12px;
            background: #b30000;
            color: #fff;
            border: none;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover { background: #990000; }
        .error {
            background: #ffe5e5;
            color: #b30000;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
            font-size: 14px;
            text-align: center;
        }
        .footer {
            margin-top: 20px;
            font-size: 12px;
            color: #666;
            text-align: center;
        }
        .demo-note {
            margin-top: 15px;
            font-size: 12px;
            color: #999;
            text-align: center;
        }
    </style>
</head>
<body>

<div class="header">Secure Online Banking <span style="font-weight:normal">(BOA)</span></div>

<div class="container">
    <div class="login-box">
        <h2>Sign In</h2>

        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post">
            <label>Email</label>
            <input type="email" name="email" placeholder="Enter your email" required>

            <label>Password</label>
            <input type="password" name="password" placeholder="Enter your password" required>

            <button type="submit">Log In</button>
        </form>

        <div class="demo-note">
           <div class="secure">Secure area</div>

<div class="link-container">
  <div class="link-row">
    <a
      title="Privacy"
      href="https://www.bankofamerica.com/security-center/privacy-overview/"
      target="_blank"
      rel="noopener"
      name="Privacy_&_Security_footer"
    >
      Privacy
    </a>

    <a
      title="Security"
      href="https://www.bankofamerica.com/security-center/overview/"
      target="_blank"
      rel="noopener"
      name="Security"
    >
      Security
    </a>

    <a
      class="last-link"
      title="Your Privacy Choices"
      href="#"
      target="_self"
      name="Your Privacy Choices"
    >
      Your Privacy Choices
      <img
        id="footer_pill"
        src="https://secure.bankofamerica.com/pa/components/modules/global-footer-module/2.5/graphic/pill.png"
        alt="Privacy choices"
      />
    </a>
  </div>
</div>
        </div>
        <div class="footer">© 2025 BOA Corporation.</div>
    </div>
</div>

</body>
</html>