<?php
// transfer.php — DEMO / PRACTICE ONLY
session_start();
if (empty($_SESSION['logged_in'])) { header('Location: login.php'); exit; }

$notice = '';
$error  = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Demo-only behavior: outbound transfers are restricted
    $bank   = trim($_POST['bank'] ?? '');
    $to     = trim($_POST['to'] ?? '');
    $amount = floatval($_POST['amount'] ?? 0);

    if (!$bank || !$to || $amount <= 0) {
        $error = 'Please complete all fields with valid information.';
    } else {
        // Always block and instruct user to contact account manager
        $notice = 'Outbound transfers are restricted on this account. Please contact your account manager to proceed.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Transfer Funds | BOA</title>
<style>
:root{ --red:#b30000; --bg:#f4f6f8; --card:#ffffff; --muted:#6b7280; }
*{ box-sizing:border-box; font-family: Inter, Arial, Helvetica, sans-serif; }
body{ margin:0; background:var(--bg); color:#111827; }
.topbar{
  background:linear-gradient(90deg,var(--red),#d10000);
  color:#fff; padding:16px 28px; display:flex; align-items:center; justify-content:space-between;
}
.topbar a{ color:#fff; text-decoration:none; font-weight:800; }

/* Sidebar spacing alignment (matches dashboard/profile) */
.container{ max-width:760px; margin:26px auto 26px 240px; padding:0 18px; }

.card{ background:var(--card); border-radius:16px; box-shadow:0 12px 30px rgba(0,0,0,.08); padding:22px; }
.card h3{ margin:0 0 10px; }
.sub{ color:var(--muted); }

label{ font-weight:800; display:block; margin:14px 0 6px; }
input, select{
  width:100%; padding:12px; border:1px solid #d1d5db; border-radius:10px; font-size:14px;
}

button{
  margin-top:18px; width:100%; padding:14px; background:var(--red); color:#fff;
  border:none; border-radius:12px; font-weight:900; cursor:pointer;
}
button:hover{ filter:brightness(.95); }

.notice{
  background:#fff7ed; color:#9a3412; border:1px solid #fed7aa;
  padding:12px 14px; border-radius:12px; font-weight:800; margin-bottom:12px;
}
.error{
  background:#fee2e2; color:#7f1d1d; border:1px solid #fecaca;
  padding:12px 14px; border-radius:12px; font-weight:800; margin-bottom:12px;
}

.helper{
  margin-top:14px; background:#f8fafc; border:1px dashed #e5e7eb;
  border-radius:12px; padding:14px; color:#374151; font-size:13px;
}

@media (max-width: 900px){
  .container{ margin-left:0; }
}
</style>
</head>
<body>

<div class="topbar">
  <div>Secure Online Banking <span style="font-weight:400">(BOA)</span></div>
  <a href="logout.php">Logout</a>
</div>

<?php include 'side.php'; ?>

<div class="container">
  <div class="card">
    <h3>Transfer Funds</h3>
    <p class="sub">Send funds to domestic or international banks. </p>

    <?php if ($notice): ?><div class="notice"><?= htmlspecialchars($notice) ?></div><?php endif; ?>
    <?php if ($error): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>

    <form method="post">
      <label for="bank">Destination Bank</label>
      <select id="bank" name="bank" required>
        <option value="">Select a bank</option>
        <option>Bank of America</option>
        <option>JPMorgan Chase</option>
        <option>Wells Fargo</option>
        <option>Citibank</option>
        <option>HSBC</option>
        <option>Barclays</option>
        <option>BNP Paribas</option>
        <option>Deutsche Bank</option>
        <option>Standard Chartered</option>
        <option>Other International Bank</option>
      </select>

      <label for="to">Recipient Name / Account Number</label>
      <input id="to" name="to" placeholder="Full name or IBAN / Account No." required>

      <label for="amount">Amount (USD)</label>
      <input id="amount" type="number" step="0.01" name="amount" placeholder="0.00" required>

      <button type="submit">Proceed Transfer</button>
    </form>

    <div class="helper">
      <strong>Notice:</strong> For security and compliance reasons, outbound transfers on this account
      require approval by your assigned account manager.
    </div>
  </div>
</div>

</body>
</html>